/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
#include <..\Originlab\oMat.h>
#include <wks2mat.h>
////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.

#include <..\Originlab\okThemeID.h>
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

void ConvertWksToMatrixAndPlot()
{
	Worksheet wks;
	wks.Create();
	wks.SetName("Data");
	wks.AddCol();
	
	XYZRange dr;								//set the XYRange
	dr.Add(wks, 0, "X");                   
	dr.Add(wks, 1, "Y");
	dr.Add(wks, 2, "Z");
	vector vX = {1,1,1,2,2,2,3,3,3};
	vector vY = {1,2,3,1,2,3,1,2,3};
	vector vZ = {5,3,7,3,6,5,0,4,3};
	
	int nSize = vX.GetSize();
    
    vX.Sort(SORT_ASCENDING);				//sort the vector data x, y 
    vY.Sort(SORT_ASCENDING);
    vZ.Sort(SORT_ASCENDING);
    
    dr.SetData(&vZ, &vY, &vX);					//put the vector vX, vY, to XYRange dr

    //examine the xyz data
    double dPrecision = 1.0e-8;				//covert wks to matrix  

    double Xmin, Ymin, dXStep, dYStep, Xmax, Ymax;
    int n;
    ocmath_xyz_examine_data(nSize, vX, vY, vZ, dPrecision, dPrecision, &n, &Xmin, &dXStep, &Xmax, &Ymin, &dYStep, &Ymax, true);
                

    int iX, iY;
    vector<double> mat;
    iX = dXStep > 0 ? (int)((Xmax - Xmin) / dXStep + 0.5) + 1 : 1; 
    iY = dYStep > 0 ? (int)((Ymax - Ymin) / dYStep + 0.5) + 1 : 1; 
    mat.SetSize(iX*iY); //set the matrix size

    //convert wks to matrix
    ocmath_convert_regular_xyz_to_matrix(nSize, vX, vY, vZ,
                mat, Xmin, dXStep, iX, Ymin, dYStep, iY);
    printf("%d scatters are discarded.\n", n);
    
    MatrixLayer ml;
    ml.Create();
    ml.SetNumRows(iY);
    ml.SetNumCols(iX);
    printf("%d * %d matrix is created.\n", iX, iY);
    
    Matrix M(ml);
    M.SetXMin(Xmin);
    M.SetXMax(Xmax);
    M.SetYMin(Ymin);
    M.SetYMax(Ymax);
    M.SetByVector(mat, true);


    //make the 3D plot
    GraphPage gp;	//create graphpage
    gp.Create("3D");

    GraphLayer gl;
    int nPlot;
    if( gp )
    {
        gl = gp.Layers();        //make plot
        if( gl )
        {
            int nPlot = gl.AddPlot(dr, ID_3D_GRAPH_SCATTER);
            gl.Rescale();
        }
    }
    
    //change the plot style
    DataPlot dp = gl.DataPlots(nPlot);
    Tree tr;
    tr = dp.GetFormat(FPB_ALL, FOB_ALL, true, true); 	// get the format tree
    
	TreeNode trSymbolShape = tree_get_node_by_nodeid(tr, OTID_CURVE_SYMBOL_SHAPE, 3);
	trSymbolShape.nVal = 1; //symbol shape set to square
	
	TreeNode trSymbolSize = tree_get_node_by_nodeid(tr, OTID_CURVE_SYMBOL_SIZE, 3);
	trSymbolSize.dVal = 12;  //symbol size set to 12.
	
	TreeNode trSymbolFillColor = tree_get_node_by_nodeid(tr, OTID_CURVE_SYMBOL_FILL_COLOR, 3);
	trSymbolFillColor.nVal = FOB_INCREMENT + 6; //Fill color change to yellow yellow
	
	dp.ApplyFormat(tr, true, true);
}
